<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Template Selector</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>

<h2>Select a Template</h2>

<!-- Dropdown for HTML templates -->
<select id="templateSelect" onchange="loadTemplate()">
    <option value="">Select a Template</option>
    <?php
    // Directory where templates are stored
    $templateDir = './templates'; // Templates directory inside root

    // Scan the directory for .html files
    foreach (new DirectoryIterator($templateDir) as $file) {
        if ($file->isFile() && strtolower($file->getExtension()) === 'html') {
            echo '<option value="' . htmlspecialchars($file->getFilename()) . '">' . htmlspecialchars($file->getFilename()) . '</option>';
        }
    }
    ?>
</select>

<div id="templateContent" style="margin-top: 20px;">
    <!-- Content of the selected template will be displayed here -->
</div>

<script>
function loadTemplate() {
    var selectedTemplate = $('#templateSelect').val();
    if (selectedTemplate) {
        $.get('templates/' + selectedTemplate, function(data) {
            $('#templateContent').html(data);
        }).fail(function(jqXHR, textStatus, errorThrown) {
            alert('Error: Could not load the template. ' + textStatus + ' - ' + errorThrown);
        });
    } else {
        $('#templateContent').html('');
    }
}
</script>

</body>
</html>
