<!DOCTYPE html> 
<html lang="en">
<head> 
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width initial-scale=1.0">
    <title>Three Columns Page</title> 
    <link rel="stylesheet" href="styles_index.css">
    <script>
        function performAICheck() {
            // Fetch the content from the dynamic content area
            var content = document.querySelector('#dynamicContent').innerText;

            // Replace single quotes with blank spaces
            content = content.replace(/'/g, " ");

            // AJAX request to ai_check.php
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "ai_check.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function() {
                if (this.readyState === XMLHttpRequest.DONE && this.status === 200) {
                    // Handle the response from ai_check.php
                    console.log(this.responseText); // Log the response
                    alert(this.responseText); // Optionally, display it in an alert
                }
            }
            xhr.send("content=" + encodeURIComponent(content));
        }
    </script>
</head> 
<body> 

<div class="header" style="...">
    <!-- Header Content -->
</div>

<div class="columns">
    <div class="first-column">
        <!-- Including content from controls.html -->
        <?php include 'templates/templates.php'; ?>
    </div> 

    <div class="second-column">
        <!-- AI Check Button (remains outside the dynamic area) -->
        <div id="aiCheckContainer">
            <button id="aiCheckButton" onclick="performAICheck()">AI Check</button>
        </div>

        <!-- Dynamic content area for fetchData_test.php -->
        <div id="dynamicContent">
            <center><img src="images/logo3.png" alt="" style="width:500px; height:500px;"></center> 
        </div>
    </div> 

    <div class="third-column">
        <!-- Including content from display.php -->
        <?php include 'display_test.php'; ?>
    </div> 
</div> 

<div class="footer">
    <!-- Footer Content -->
</div> 

</body> 
</html>

