<?php

/**
 * Copyright (c) 2022-present Tectalic (https://tectalic.com)
 *
 * For copyright and license information, please view the LICENSE file that was distributed with this source code.
 *
 * Please see the README.md file for usage instructions.
 */

declare(strict_types=1);

namespace Tectalic\OpenAi\Models\ChatCompletions;

use Tectalic\OpenAi\Models\AbstractModel;

final class CreateResponseChoicesItemMessage extends AbstractModel
{
    /**
     * List of required property names.
     *
     * These properties must all be set when this Model is instantiated.
     */
    protected const REQUIRED = ['role'];

    /**
     * The role of the author of this message.
     *
     * Allowed values: 'system', 'user', 'assistant', 'function'
     *
     * @var string
     */
    public $role;

    /**
     * The contents of the message.
     *
     * @var string|null
     */
    public $content;

    /**
     * The name and arguments of a function that should be called, as generated by the
     * model.
     *
     * @var \Tectalic\OpenAi\Models\ChatCompletions\CreateResponseChoicesItemMessageFunctionCall
     */
    public $function_call;
}
